#!/usr/bin/env python

import sys

def main():
    window = 25000
    #window = 250000
    max_range = 99
    gifs = []
    for t in range(0, 241, 5):
        sim_fn  = "sim.%04d" % (t,)
        xref_fn = "xref.%04d" % (t,)
        ppm_fn  = "i.%04d.ppm" % (t,)
        gif_fn  = "i.%04d.gif" % (t,)
        gifs.append(gif_fn)
        
        sys.stdout.write("./sim-airplane2 rfm -o %s -S %d\n" % (sim_fn, t))
        sys.stdout.write("./eb-xambi -o %s -M %d -w %d -d 0.0002 rfm %s\n" % (
            xref_fn, max_range, window, sim_fn))
        sys.stdout.write("./plot_xambi_tool.m %s %s\n" % (xref_fn, ppm_fn))
        sys.stdout.write("convert -resize 800%% %s %s\n" % (ppm_fn, gif_fn))

    sys.stdout.write("gifsicle -d 50 %s >animated.gif\n" % (' '.join(gifs)))

if __name__ == '__main__':
    main()
